#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;
using System.IO;

#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_DataAccessException : BaseTest 
	{
		private string exceptionText = "DataAccessException";
		private string genericErrorText = "Exception of type 'gov.va.med.vbecs.Common.DataAccessLayerException' was thrown.";

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();
		}


		[Test]
		public void Ctor_Blank_Pass()
		{
			try
			{
				throw new Common.DataAccessLayerException();
			}
            catch (Common.DataAccessLayerException ex)
			{
				Assert.IsTrue("Error in the application." == ex.Message);
			}
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Blank_Fail()
		{
		}

		[Test]
		public void Ctor_String_Pass()
		{
			try
			{
				throw new Common.DataAccessLayerException(exceptionText);
			}
			catch (Common.DataAccessLayerException ex)
			{
				Assert.IsTrue(exceptionText == ex.Message);
			}
		}

		[Test]
		public void Ctor_String_Fail()
		{
			try
			{
				throw new Common.DataAccessLayerException(null);
			}
			catch (Common.DataAccessLayerException ex)
			{
				Assert.IsTrue(genericErrorText == ex.Message);
			}
		}

		[Test]
		public void Ctor_String_Exception_Pass()
		{
			try
			{
				throw new Common.DataAccessLayerException(exceptionText, new System.Exception(exceptionText));
			}
			catch (Common.DataAccessLayerException ex)
			{
				Assert.IsTrue(exceptionText == ex.Message);
			}
		}

		[Test]
		public void Ctor_String_Exception_Fail()
		{
			try
			{
				throw new Common.DataAccessLayerException(null, new System.Exception(exceptionText));
			}
			catch (Common.DataAccessLayerException ex)
			{
				Assert.IsTrue(genericErrorText == ex.Message);
				Assert.IsTrue(ex.InnerException.Message == exceptionText);
			}
		}

		[Test]
		public void GetObjectData_Pass()
		{
            Common.DataAccessLayerException _originalXcp = new Common.DataAccessLayerException(exceptionText, new System.Exception(exceptionText));

			BinaryFormatter _formatter = new BinaryFormatter();
			MemoryStream _stream = new MemoryStream();

			_formatter.Serialize( _stream, _originalXcp );

			_stream.Seek(0, SeekOrigin.Begin );

            Common.DataAccessLayerException _reincarnatedXcp = (Common.DataAccessLayerException)_formatter.Deserialize(_stream);
			
			Assert.IsNotNull( _reincarnatedXcp );
			Assert.IsTrue( _originalXcp.DBConnectionString == _reincarnatedXcp.DBConnectionString );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetObjectData_Fail()
		{
		}

		[Test]
		public void DBConnectionString_Pass()
		{
			try
			{
				throw new Common.DataAccessLayerException(exceptionText);
			}
			catch (Common.DataAccessLayerException ex)
			{
				string testValue = ex.DBConnectionString;
				Assert.IsTrue(ex.DBConnectionString == testValue);
			}
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void DBConnectionString_Fail()
		{
		}

	}

}
#endif
